package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * author:  ljc
 * date:    2023/4/27
 * desc:    订单支付通知类型
 */
public enum OrderNotifyType {
    NO_PAY(1, "未支付通知"),
    MEETING_FINISH_PAY(2, "直播间完成支付通知"),
    NET_SCHOOL_FINISH_PAY(3, "百家云网校支付完成通知");

    private final int value;
    private final String desc;

    OrderNotifyType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private static final Set<Integer> ALL_TYPE;
    static {
        ALL_TYPE = Arrays.stream(OrderNotifyType.values())
                .map(OrderNotifyType::getValue)
                .collect(Collectors.toSet());
    }

    public static boolean contain(Integer value) {
        return ALL_TYPE.contains(value);
    }
}
