package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 算子计算结果集合类型枚举
 */
public enum OperatorResultCustomerType implements IOperatorResultType {

    LEADS_ID(1,"crm leadsId"),

    MOBILE(2,"手机号"),

    WEWORK_CONTACT_ID(3,"企微联系人ID（加密）"),

    DECRY_WEWORK_CONTACT_ID(4,"解密版企微联系人ID"),

    WEWORK_CONTACT_DIGIT_ID(5,"营销宝企微联系人ID"),

    CUSTOMER_MAIN_ID(6,"客户中心用户主ID"),

    CUSTOMER_NUM(7,"customerNum")

    ;

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    OperatorResultCustomerType(Integer type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, OperatorResultCustomerType> MAP;

    static {
        MAP = Arrays.stream(OperatorResultCustomerType.values()).collect(Collectors.toMap(OperatorResultCustomerType::getType, Function.identity()));
    }

    public static OperatorResultCustomerType getByType(Integer type) {
        return MAP.get(type);
    }
}
