package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: 会议状态
 * @author: lwl
 * @date: 2021/6/3
 **/
public enum MeetingStatus implements EnumService{
    UN_START(0, "未开始"),
    MEETING(1, "进行中"),
    FINISHED(2, "已结束"),
    CANCELED(3, "已取消");

    private final int value;
    private final String desc;

    MeetingStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, MeetingStatus> CACHE;

    static {
        CACHE = new HashMap<>();
        for (MeetingStatus item : values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static MeetingStatus get(int status) {
        return CACHE.get(status);
    }
}
