package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum MeetingPushType implements EnumService{

    NORMAL_MEETING(0,"常规直播"),
    LIVE_MEETING(1,"推流直播");

    private final int value;
    private final String desc;

    MeetingPushType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, MeetingPushType> CACHE;

    static {
        CACHE = new HashMap<>();
        for (MeetingPushType item : MeetingPushType.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static MeetingPushType get(int value) {
        return CACHE.get(value);
    }
}
