package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum MaterialType implements EnumService{
    IMAGE(1, "image"),
    FILE(2, "file"),
    VOICE(3, "voice"),
    VIDEO(4, "video");

    private final int value;
    private final String desc;

    MaterialType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, MaterialType> CACHE;


    static {
        CACHE = new HashMap<>();
        for (MaterialType item : values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static MaterialType get(int status) {
        return CACHE.get(status);
    }

}
