package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum GroupTypeEnum implements EnumService {
    RADAR("radar", "互动雷达"),

    DYNAMIC_FORM("dynamicForm", "动态表单"),

    CHANNEL_PLAN("channelPlan", "渠道活码"),

    CAHNNEL_MANAGER("channelManager", "渠道管理");

    private final String code;

    private final String desc;

    public String getCode() {
        return code;
    }

    @Override
    public int getValue() {
        return 0;
    }

    public String getDesc() {
        return desc;
    }

    GroupTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<String, GroupTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (GroupTypeEnum e:values()) {
            CACHE.put(e.code, e);
        }
    }

    public static GroupTypeEnum get(String value) {
        return CACHE.get(value);
    }
}
