package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zhangjing
 * @date 2021/6/19 6:20 下午
 */
public enum GroupSendTaskType implements EnumService {

    SIDEBAR(0, "手动群发"),

    QYAPI(1, "企业群发"),

    CLIENT(2, "成员个人群发"),

    VIP_GROUP_SEND_CUSTOMER(3, "vip群发客户"),

    VIP_GROUP_SEND_CHATROOM(4, "vip群发群"),

    VIP_GROUP_SEND_NOTICE(5, "vip群发群公告");

    private final int value;

    private final String desc;

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    GroupSendTaskType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private static final Map<Integer, GroupSendTaskType> MAP;

    static {
        MAP = Arrays.stream(values()).collect(Collectors.toMap(GroupSendTaskType::getValue, a -> a));
    }

    public static GroupSendTaskType getType(int value) {
        return MAP.get(value);
    }
}
