package com.kuaike.scrm.common.enums;

/**
 * @description: 文件处理状态
 * @author: liuguohong
 * @create: 2021/04/16 13:40
 */

public enum FileStatus {
    FAIL(-1,"拉取失败"),

    INIT(0, "刚入库"),

    ALREADY_TO_OSS(1, "已上传到OSS"),

    ALREAD_SYNC_ES(2, "已同步到ES"),

    HAVE_CONVERT_TO_MP3(3,"已经转换成mp3"),  // voice 类型 arm格式文件需要

    CONVERT_TO_MP3_FAIL(4,"转换mp3失败");

    private final int status;

    private final String desc;

    public int getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    FileStatus(int status, String desc) {
        this.status = status;
        this.desc = desc;
    }
}
