package com.kuaike.scrm.common.enums;

/**
 * 枚举类使用接口
 * @author shanyu
 *
 */
public interface EnumService {
	
	int getValue();
	
	String getDesc();

	static <E extends Enum<E> & EnumService> E getByValue(Class<E> enumClass, Integer value) {
		if (value == null) return null;
		E[] enumConstants = enumClass.getEnumConstants();
		for (E item : enumConstants) {
			if (value.equals(item.getValue())) {
				return item;
			}
		}
		return null;
	}

}
