package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum ContactStageStatus implements EnumService{
    UN_FLOWING(0, "未跟进"),
    FLOWING(1, "跟进中"),
    END(2, "跟进结束");

    private final int id;
    private final String name;

    ContactStageStatus(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, ContactStageStatus> cache;

    static {
        cache = new HashMap<>(3);
        for (ContactStageStatus item : ContactStageStatus.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static ContactStageStatus get(int status) {
        return cache.get(status);
    }
}
