/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @title BizType
 * @author yanmaoyuan
 * @date 2021年4月25日
 * @version 1.0
 */
public enum BizType implements EnumService {
    TRIAL(1, "试用"),
    NORMAL(2, "正式");

    private final int id;
    private final String desc;

    BizType(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return id;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, BizType> cache;

    static {
        cache = new HashMap<>(3);
        for (BizType item : BizType.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static BizType get(int status) {
        return cache.get(status);
    }

}
