package com.kuaike.scrm.common.dto;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;

/**
 * @description:
 * @author: liuguohong
 * @create: 2021/04/20 15:02
 */
@Data
@Slf4j
@SuppressWarnings("java:S1948")
public class TalkerMessageRespDto implements Serializable {


    private static final long serialVersionUID = 3109729464995198096L;

    private String msgId;
    private String senderId;
    /**
     * 联系人remark
     */
    private String senderName;
    /**
     * 联系人名
     */
    private String sendOriginName;

    private String avatar;
    //把senderId 是weworkUserId转为weworkUserNum提供给前端
    private String sendNum;

    private Date msgTime;

    private String msgText;

    private Map<String,Object> message;

    private String requestId;

    private Integer fileStatus;// vip文件上报到ES的状态

    private Boolean isSend;

    //引用消息
    private TalkerMessageRespDto quoteMsgRespDto;
}
