/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package com.kuaike.scrm.common.dto;

import java.io.Serializable;
import java.util.Objects;

import com.google.common.base.Preconditions;
import lombok.Data;

/**
 * @title IdDto
 * @author yanmaoyuan
 * @date 2021年5月8日
 * @version 1.0
 */
@Data
public class IdDto implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    public void validateParams() {
        Preconditions.checkArgument(Objects.nonNull(id), "id不能为空");
    }
}
