package com.kuaike.scrm.common.dto;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @Date: 2021/11/18 11:19
 * @Author: dayu
 */

@Data
public class AppOpenBaseReqDto {

    private String appId;

    private String url;

    private String fkId;

    private String fkKey;

    private String fkSecret;

    /**
     * 商户对应的网校域名
     */
    private String netSchoolDomain;

    /**
     * 商户对应的网校partnerId
     */
    private String netSchoolPartnerId;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(appId), "appId不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(url), "链接不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(fkId), "ID不能为空");
        Preconditions.checkArgument(StringUtils.isNotBlank(fkKey), "Key不能为空");
    }


}
