/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.excel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;
import java.util.List;

public class SecondToTimeStrConvertor
implements Converter<Integer> {
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public Class<?> supportJavaTypeKey() {
        return List.class;
    }

    public WriteCellData<?> convertToExcelData(WriteConverterContext<Integer> context) {
        String timeStr = this.convertSecondToTimeStr((Integer)context.getValue());
        WriteCellData result = new WriteCellData();
        result.setStringValue(timeStr);
        result.setType(CellDataTypeEnum.STRING);
        return result;
    }

    private String convertSecondToTimeStr(Integer duration) {
        if (duration == null || duration <= 0) {
            return "00\u520600\u79d2";
        }
        StringBuilder sb = new StringBuilder();
        int hour = duration / 3600;
        int remainder = duration % 3600;
        int minute = remainder / 60;
        int second = remainder % 60;
        if (hour > 0) {
            sb.append(hour).append("\u5c0f\u65f6");
        }
        if (minute > 0) {
            sb.append(minute).append("\u5206\u949f");
        }
        if (second > 0) {
            sb.append(second).append("\u79d2");
        }
        return sb.toString();
    }
}

