/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.dto;

import com.baijiayun.duanxunbao.common.dto.PageDto;
import com.baijiayun.duanxunbao.common.dto.ResultError;
import com.baijiayun.duanxunbao.common.enums.ResultCode;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Result<T>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Result.class);
    private static final long serialVersionUID = 1L;
    private String msg = "";
    private Integer code = 0;
    private T data;
    private PageDto pageDto;

    public Result() {
    }

    public Result(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Result<T> success(String message) {
        this.msg = message;
        this.code = ResultCode.SUCCESS.getCode();
        return this;
    }

    @JsonIgnore
    public boolean isSuccess() {
        return ResultCode.SUCCESS.getCode().equals(this.code);
    }

    @JsonIgnore
    public boolean isDataValid() {
        return this.isSuccess() && this.data != null;
    }

    public Result<T> code(Integer code) {
        this.code = code;
        return this;
    }

    public Result<T> msg(String message) {
        this.msg = message;
        return this;
    }

    public Result<T> data(T data) {
        this.data = data;
        return this;
    }

    public Result<T> pageDto(PageDto pageDto) {
        this.pageDto = pageDto;
        return this;
    }

    public static <T> Result<T> ok() {
        Result<T> r = new Result<T>();
        r.setCode(ResultCode.SUCCESS.getCode());
        return r;
    }

    public static <T> Result<T> ok(String msg) {
        Result<String> r = new Result<String>();
        r.setCode(ResultCode.SUCCESS.getCode());
        r.setData(msg);
        r.setMsg(msg);
        return r;
    }

    public static Result<Boolean> ok(Boolean data) {
        Result<Boolean> r = new Result<Boolean>();
        r.setCode(ResultCode.SUCCESS.getCode());
        r.setData(data);
        return r;
    }

    public static <T> Result<T> ok(T data) {
        Result<T> r = new Result<T>();
        r.setCode(ResultCode.SUCCESS.getCode());
        r.setData(data);
        return r;
    }

    public static <T> Result<T> ok(T data, PageDto pageDto) {
        Result<T> r = new Result<T>();
        r.setCode(ResultCode.SUCCESS.getCode());
        r.setData(data);
        r.setPageDto(pageDto);
        return r;
    }

    public static <T> Result<T> ok(String msg, T data) {
        Result<T> r = new Result<T>();
        r.setCode(ResultCode.SUCCESS.getCode());
        r.setData(data);
        r.setMsg(msg);
        return r;
    }

    public static <T> Result<T> error() {
        return Result.error(ResultCode.SYSTEM_ERROR);
    }

    public static <T> Result<T> error(String msg, T data) {
        Result<T> r = new Result<T>();
        r.setCode(ResultCode.SYSTEM_ERROR.getCode());
        r.setMsg(msg);
        r.setData(data);
        return r;
    }

    public static <T> Result<T> error(String msg) {
        return Result.error(ResultCode.SYSTEM_ERROR.getCode(), msg);
    }

    public static <T> Result<T> error(int code, String msg) {
        Result<T> r = new Result<T>();
        r.setCode(code);
        r.setMsg(msg);
        return r;
    }

    public static <T> Result<T> error(ResultError error) {
        return Result.error(error.getCode(), error.getMsg());
    }

    public static <T> Result<T> error(ResultError error, String msg) {
        return Result.error(error.getCode(), msg);
    }

    public static <T> Result<T> error(Result<?> result) {
        return Result.error(result.getCode(), result.getMsg());
    }

    public String getMsg() {
        return this.msg;
    }

    public Integer getCode() {
        return this.code;
    }

    public T getData() {
        return this.data;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        return !(this$pageDto == null ? other$pageDto != null : !((Object)this$pageDto).equals(other$pageDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : ((Object)$pageDto).hashCode());
        return result;
    }

    public String toString() {
        return "Result(msg=" + this.getMsg() + ", code=" + this.getCode() + ", data=" + this.getData() + ", pageDto=" + this.getPageDto() + ")";
    }
}

