/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.dto;

import io.swagger.annotations.ApiModel;
import java.io.Serializable;

@ApiModel(description="\u5206\u9875\u53c2\u6570")
public class PageDto
implements Serializable {
    private static final long serialVersionUID = 9103057732548944201L;
    private static final int DEF_PAGE_SIZE = 20;
    private static final int DEF_PAGE_NUM = 1;
    private static final PageDto DEF_PAGE_DTO = new PageDto();
    private Integer count = 0;
    private Integer curPageCount;
    private Integer pageNum;
    private Integer pageSize;
    private boolean needCount = true;

    public static PageDto getDefPageDto() {
        try {
            return (PageDto)DEF_PAGE_DTO.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public PageDto() {
        this.pageNum = 1;
        this.pageSize = 20;
    }

    public PageDto(Integer pageNum, Integer pageSize) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }

    public void setCount(Integer count) {
        if (count == null) {
            count = 0;
        }
        this.count = count;
    }

    public void setCurPageCount(Integer curPageCount) {
        if (curPageCount == null) {
            curPageCount = 0;
        }
        this.curPageCount = curPageCount;
    }

    public Integer getPageNum() {
        if (this.pageNum == null || this.pageNum <= 0) {
            this.pageNum = 1;
        }
        return this.pageNum;
    }

    public Integer getTotalPageNum() {
        if (this.count == 0) {
            return 0;
        }
        return (int)Math.ceil((double)this.count.intValue() / this.pageSize.doubleValue());
    }

    public void setPageNum(Integer pageNum) {
        if (pageNum == null || pageNum <= 0) {
            pageNum = 1;
        }
        this.pageNum = pageNum;
    }

    public void increasePageNum() {
        PageDto pageDto = this;
        Integer n = pageDto.pageNum;
        Integer n2 = pageDto.pageNum = Integer.valueOf(pageDto.pageNum + 1);
    }

    public Integer getPageSize() {
        if (this.pageSize == null || this.pageSize <= 0) {
            this.pageSize = 20;
        }
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        if (pageSize == null || pageSize <= 0) {
            pageSize = 20;
        }
        this.pageSize = pageSize;
    }

    public void validate() {
        int num = this.getPageNum();
        int size = this.getPageSize();
        int cnt = this.getCount();
        if (cnt <= 0) {
            this.setPageNum(1);
            return;
        }
        int lastPageNum = (cnt - 1) / size + 1;
        if (lastPageNum > num) {
            this.setCurPageCount(size);
            return;
        }
        int lastPageSize = (cnt - 1) % size + 1;
        this.setCurPageCount(lastPageSize);
        if (lastPageNum < num) {
            this.setPageNum(lastPageNum);
        }
    }

    public int firstNum() {
        int num = this.getPageNum();
        int size = this.getPageSize();
        return (num - 1) * size;
    }

    public int getOffset() {
        return this.firstNum();
    }

    public String toString() {
        return "PageDto(count=" + this.getCount() + ", curPageCount=" + this.getCurPageCount() + ", pageNum=" + this.getPageNum() + ", pageSize=" + this.getPageSize() + ", needCount=" + this.isNeedCount() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageDto)) {
            return false;
        }
        PageDto other = (PageDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNeedCount() != other.isNeedCount()) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        Integer this$curPageCount = this.getCurPageCount();
        Integer other$curPageCount = other.getCurPageCount();
        if (this$curPageCount == null ? other$curPageCount != null : !((Object)this$curPageCount).equals(other$curPageCount)) {
            return false;
        }
        Integer this$pageNum = this.getPageNum();
        Integer other$pageNum = other.getPageNum();
        if (this$pageNum == null ? other$pageNum != null : !((Object)this$pageNum).equals(other$pageNum)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        return !(this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNeedCount() ? 79 : 97);
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        Integer $curPageCount = this.getCurPageCount();
        result = result * 59 + ($curPageCount == null ? 43 : ((Object)$curPageCount).hashCode());
        Integer $pageNum = this.getPageNum();
        result = result * 59 + ($pageNum == null ? 43 : ((Object)$pageNum).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        return result;
    }

    public Integer getCount() {
        return this.count;
    }

    public Integer getCurPageCount() {
        return this.curPageCount;
    }

    public boolean isNeedCount() {
        return this.needCount;
    }

    public void setNeedCount(boolean needCount) {
        this.needCount = needCount;
    }
}

