package com.baijiayun.duanxunbao.common.excel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;

import java.util.List;

/**
 * @author Created by chenjiaqiang on 2023/12/26
 **/
public class PriceConvertor implements Converter<Long> {

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        return List.class;
    }


    @Override
    public WriteCellData<?> convertToExcelData(WriteConverterContext<Long> context) {
        Long price = context.getValue();
        String value;
        if (price == null) {
            value = "0";
        } else {
            double priceInYuan = price / 10000.0;
            value = Double.toString(priceInYuan);
        }
        WriteCellData<String> result = new WriteCellData<>();
        result.setStringValue(value);
        result.setType(CellDataTypeEnum.STRING);
        return result;
    }
}
