package com.baijiayun.duanxunbao.common.excel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;
import org.apache.commons.lang3.time.FastDateFormat;

import java.util.List;

/**
 * @author Created by chenjiaqiang on 2024/05/11
 **/
public class LongTime2StrConvertor implements Converter<Long> {

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        return List.class;
    }

    @Override
    public WriteCellData<?> convertToExcelData(WriteConverterContext<Long> context) {
        Long time = context.getValue();
        String value;
        if (time == null || time <= 0L) {
            value = "";
        } else {
            FastDateFormat df = FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss");
            value = df.format(time);
        }
        WriteCellData<String> result = new WriteCellData<>();
        result.setStringValue(value);
        result.setType(CellDataTypeEnum.STRING);
        return result;
    }

}
