package com.baijiayun.duanxunbao.common.excel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;
import org.apache.commons.lang3.time.FastDateFormat;

import java.util.List;

/**
 * 时间戳转换为日期格式 "yyyy-MM-dd"
 * @author lwl
 */
public class LongTime2DayConvertor implements Converter<Long> {

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        return List.class;
    }

    @Override
    public WriteCellData<?> convertToExcelData(WriteConverterContext<Long> context) {
        Long time = context.getValue();
        String value;
        if (time == null || time <= 0L) {
            value = "";
        } else {
            FastDateFormat df = FastDateFormat.getInstance("yyyy-MM-dd");
            value = df.format(time);
        }
        WriteCellData<String> result = new WriteCellData<>();
        result.setStringValue(value);
        result.setType(CellDataTypeEnum.STRING);
        return result;
    }

}
