package com.baijiayun.duanxunbao.common.excel;

import lombok.extern.slf4j.Slf4j;

import java.io.*;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;

@Slf4j
public final class FileDownloadConvertor {

    private FileDownloadConvertor() {}

    public static File convertor(String imgUrl, String filePath, String fileName) {
        log.info("convertor imgUrl: {}, path: {}", imgUrl, filePath);
        File imageFile = new File(filePath, fileName);
        try (OutputStream outputStream = Files.newOutputStream(imageFile.toPath())) {
            URL url = new URL(imgUrl);
            URLConnection connection = url.openConnection();
            InputStream inputStream = connection.getInputStream();

            byte[] buffer = new byte[4096];
            int bytesRead;

            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }

            inputStream.close();

            return imageFile;
        }catch (Exception e) {
            log.error("convertor url with error", e);
        }
        return null;
    }
}
