package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum WeekDayEnum implements EnumService {
    MONDAY(1,"周一"),
    TUESDAY(2,"周二"),
    WEDNESDAY(3,"周三"),
    THURSDAY(4,"周四"),
    FRIDAY(5,"周五"),
    SATURDAY(6,"周六"),
    SUNDAY(7,"周日")
    ;

    private final int value;
    private final String desc;

    WeekDayEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, WeekDayEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (WeekDayEnum item : WeekDayEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static WeekDayEnum get(int value) {
        return CACHE.get(value);
    }
}
