package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum UserLoginType implements EnumService {
    APP(1,"C端登录"),
    MANAGER(2,"B端登录"),
    ADMIN(3,"管理端登录")
    ;

    private final int value;
    private final String desc;

    UserLoginType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, UserLoginType> CACHE;
    static {
        CACHE = new HashMap<>();
        for (UserLoginType item : UserLoginType.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static UserLoginType get(int value) {
        return CACHE.get(value);
    }
}
