package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum UnlockModeEnum implements EnumService {
    FREE(1,"自由解锁"),
    CHECKPOINT(2,"闯关解锁"),
    DATE(3,"日期解锁"),
    ON_WHICH_DAY(4,"按天解锁"),
    FIXED_DATE(5,"固定日期解锁");

    private final int value;
    private final String desc;

    UnlockModeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, UnlockModeEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (UnlockModeEnum item : UnlockModeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static UnlockModeEnum get(int value) {
        return CACHE.get(value);
    }
}
