package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @Date: 2021/10/27 17:15
 * @Author: dayu
 */

public enum SystemTypeEnum {

    UNKNOW(0, "unknow", "未知"),
    DXB_MANAGER(1,"dxb_manager","短训宝manager"),
    SHOP_PHP(2,"shop_php","店铺php服务")
    ;

    private int value;
    private String name;
    private String desc;

    SystemTypeEnum(int value, String name, String desc) {
        this.value = value;
        this.name = name;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, SystemTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (SystemTypeEnum item : SystemTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static SystemTypeEnum get(Integer value) {
        return CACHE.get(value);
    }
}