package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 */

public enum SystemRoleEnum implements EnumService {
    ADMIN_USER(1, "管理员"),
    NORMAL(2, "普通员工");

    private final int value;
    private final String name;

    SystemRoleEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, SystemRoleEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (SystemRoleEnum item : SystemRoleEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static SystemRoleEnum get(int value) {
        return CACHE.get(value);
    }
}
