package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum SysConfEnum implements EnumService {
    NOTICE(1,"通知消息设置");

    private final Integer value;
    private final String desc;
    SysConfEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, SysConfEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (SysConfEnum item : SysConfEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static SysConfEnum get(int value) {
        return CACHE.get(value);
    }
}
