package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum ShowStatusEnum implements EnumService {
    INVISIBLE(0,"隐藏"),
    VISIBLE(1,"显示")
            ;

    private final int value;
    private final String desc;

    ShowStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, ShowStatusEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (ShowStatusEnum item : ShowStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static ShowStatusEnum get(int value) {
        return CACHE.get(value);
    }
}
