package com.baijiayun.duanxunbao.common.enums;

import com.baijiayun.duanxunbao.common.dto.ResultError;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 错误码
 * 五位组成 1 0000
 * 100 以内为通用错误码
 * 1-用户端错误
 * 2-当前系统异常
 * 3-第三方服务异常
 * 大的错误类间的步长间距预留100
 */
public enum ResultCode implements ResultError {

    SUCCESS(200, "成功"),

    USER_ERROR(10001, "用户请求服务异常"),
    USER_SIGN_ERROR(10002, "签名校验失败"),
    USER_DOMAIN_NOT_FOUND(10003, "用户域名不存在"),
    USER_LOGIN_FAILED(10100, "用户登录失败"),
    USER_INVALID_PASSWORD(10101, "账号或密码错误"),
    USER_INVALID_CAPTCHA(10102, "验证码错误"),
    USER_LOGIN_EXPIRED(10103, "登录超时"),
    USER_PASSWORD_NOT_SET(10104, "账号未修改过密码，请先修改密码再登录"),
    USER_ACCOUNT_OVER_LIMIT(10105, "登录失败，账号超过限制"),
    USER_USERINFO_NOT_FOUND(10106, "登录失败，需要微信授权"),
    USER_NO_AUTH(10200, "您没有权限进行该操作"),
    USER_AUTH_EXPIRED(10201, "授权已过期"),
    USER_NOT_LOGIN(10202, "用户未登录"),
    USER_TOKEN_EXPIRE(10203, "用户token过期"),
    USER_TOKEN_INVALID(10204, "用户token无效"),
    USER_DISABLED(10205, "账号已禁用"),
    USER_IN_BLACKLIST(10206, "暂无访问权限，请联系管理员。"),

    USER_PARAM_ERROR(10300, "用户请求参数错误"),
    USER_PARAM_REQUIRED(10301, "缺少必要的请求参数"),

    USER_REGISTER_FAILED(10400, "用户注册失败"),
    USER_REGISTERED(10410, "用户已注册"),
    USER_MOBILE_REGISTERED(10411, "用户手机号已注册"),
    USER_UNIONID_REGISTERED(10412, "用户unionid已注册"),

    USER_TICKET_INVALID(10500, "用户ticket无效"),
    USER_TICKET_EXPIRED(10501, "用户ticket过期"),
    USER_TICKET_NOT_FOUND(10502, "用户ticket不存在"),
    USER_TICKET_EXISTS(10503, "用户ticket已存在"),

    OPENAPI_INVALID_TOKEN(10600, "无效的Token"),
    OPENAPI_INVALID_CALLBACK_URL(10601, "无效的回调地址"),
    OPENAPI_ACCESS_DENIED(10602, "Access Denied"),
    OPENAPI_REQUEST_EXCEED(10603, "超出请求次数限制"),

    USER_BIND_MOBILE_FAILED(10700, "绑定手机号失败"),
    USER_BIND_MOBILE_EXISTS(10701, "已经绑定了其他手机号"),
    USER_BIND_MOBILE_WITH_WEIXIN(10702, "该手机号已经绑定过其他微信账号"),

    INVALID_PARTNER_ID(10800, "无效的PartnerID"),
    PARTNER_ID_NOT_FOUND(10801, "PartnerID不存在"),

    SYSTEM_ERROR(20001, "系统执行出错"),

    BUSINESS_ERROR(20100, "业务处理异常"),
    BIZ_NUM_ERROR(20101, "商户编号获取失败"),
    FINISH_PRE_ASSIGNMENT(20102, "请先完成上节任务"),
    NOT_BUY_PERIOD(20103, "您未购买该营期"),
    REACH_UNLOCK_LIMIT(20104, "周期内解锁的任务已达上限"),
    NOT_REACH_UNLOCK_DATE(20105, "未到指定的解锁日期"),

    OFFICIAL_ACCOUNT_NOT_FOUND(20200, "公众号不存在"),
    BIZ_NOT_BINDING_OFFICIAL_ACCOUNT(20201, "商户未授权公众号"),
    BIZ_HAVA_AUTH_PLATFORM(20202,"商户已授权到开放平台,不能再设置为商户模式"),
    APPID_ALREADY_EXISTS(20203,"appId已被使用，请检查配置～"),

    MARKET_PLAN_STOP(20301, "活动已经结束，下次早点来哦～"),
    MARKET_PLAN_TASK_FINISHED(20302, "您已经参加过此活动，请勿重复参加哦～"),
    MARKET_PLAN_VIDEO_NOT_FINISHED(20303, "看完视频才能答题哦～"),
    MARKET_PLAN_QUESTION_IS_UPDATED(20304, "题目已更新，请刷新页面重新答题～"),
    MARKET_PLAN_ANSWER_NOT_FINISHED(20305, "作答不完整,请重新提交～"),
    MARKET_PLAN_CUSTOMER_AUDIT(20306, "您的申请已提交正在审核中，请耐心等待～"),
    MARKET_PLAN_WAIT_START(20307, "活动还未开始哦~"),
    MARKET_PLAN_NO_PERMISSION(20308, "您没有权限参加此活动"),

    MENU_NAME_DUPLICATE(20401, "已经存在该名字的菜单"),
    MENU_PARENT_NOT_EXISTS(20402, "父菜单不存在"),
    MENU_PARENT_ERROR(20403, "不能设置自己为父菜单"),
    MENU_NOT_EXISTS(20404, "菜单不存在"),
    MENU_EXISTS_CHILDREN(20405, "存在子菜单，无法删除"),
    MENU_PARENT_NOT_DIR_OR_MENU(20406, "父菜单的类型必须是目录或者菜单"),

    SERVICE_ERROR(30001, "调用第三方服务出错"),
    NOTIFICATION_ERROR(30100, "通知服务出错"),
    SMS_ERROR(30101, "短信服务出错"),
    WEIXIN_ERROR(30200, "调用微信服务失败"),
    WEWORK_ERROR(30300, "调用企微服务失败");

    private final Integer code;
    private final String msg;

    ResultCode(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    @Override
    public Integer getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return msg;
    }

    private static final Map<Integer, ResultCode> MAP;

    static {
        MAP = Maps.newHashMap();
        for (ResultCode value : ResultCode.values()) {
            MAP.put(value.getCode(), value);
        }
    }

    public static ResultCode resultCodeOf(int code){
        return MAP.getOrDefault(code, SYSTEM_ERROR);
    }
}