package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum PeriodStatusEnum implements EnumService {
    NOT_OPEN(0,"未开始"),
    RECRUIT_IN_PROCESS(1,"招生中"),
    WAITING_OPEN(2,"等待开营"),
    OPENING(3,"开营中"),
    FINISHED(4,"已结束")
            ;

    private final int value;
    private final String desc;

    PeriodStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, PeriodStatusEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (PeriodStatusEnum item : PeriodStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static PeriodStatusEnum get(int value) {
        return CACHE.get(value);
    }
}
