package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum NoticeMsgEnum{
    SYSTEM(1,"系统消息","systemNotice"),
    WEWORK(2,"企业微信","weworkNotice")
    ;

    private final Integer value;
    private final String desc;
    private final String classDesc;

    NoticeMsgEnum(Integer value, String desc, String classDesc) {
        this.value = value;
        this.desc = desc;
        this.classDesc = classDesc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public String getClassDesc() {
        return classDesc;
    }

    private static final Map<Integer, NoticeMsgEnum> CACHE;
    static {
        CACHE = new HashMap<>();
        for (NoticeMsgEnum item : NoticeMsgEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static NoticeMsgEnum get(int value) {
        return CACHE.get(value);
    }
}
