package com.baijiayun.duanxunbao.common.enums;

import com.google.common.collect.ImmutableMap;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author Created by chenjiaqiang on 2023/11/04
 **/
@Getter
public enum LoginType {

    SYSTEM_PWD(1, "系统用户名和密码"),
    SMS_CODE(2, "短信验证码登录"),
    OFFICIAL_SILENT(3, "微信公众号静默登录")

    ;

    private final int type;

    private final String desc;

    private static final Map<Integer, LoginType> MAP;

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(LoginType.values()).collect(Collectors.toMap(LoginType::getType, e -> e)));
    }

    LoginType(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static LoginType getByType(int type) {
        return MAP.get(type);
    }


}
