package com.baijiayun.duanxunbao.common.enums;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class EnumSourceConstant implements Serializable {

    private static final long serialVersionUID = -7504557678928058019L;

    private int value;

    private String desc;

    public static EnumSourceConstant from(EnumService service) {
        if (service == null) {
            return null;
        }
        return new EnumSourceConstant(service.getValue(), service.getDesc());
    }

}
