package com.baijiayun.duanxunbao.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum BindEnum implements EnumService {
    ALREADY_ACTIVE(0, "已绑定"),
    DISABLED(1, "未绑定");

    private int value;
    private String name;

    BindEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, BindEnum> cache;

    static {
        cache = new HashMap<>();
        for (BindEnum item : BindEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static BindEnum get(Integer value) {
        return cache.get(value);
    }
}
