package com.baijiayun.duanxunbao.common.dto.sms;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author sunwen
 */
@Data
@ApiModel(value = "短信登录请求参数")
public class SmsLoginReqDto {
    @ApiModelProperty(value = "商户ID", notes = "前端不传的话，取自定义域名映射商户", hidden = true)
    private Long bizId;
    @ApiModelProperty(notes = "手机号", required = true)
    private String mobile;
    @ApiModelProperty(notes = "x轴坐标")
    private String x;
    @ApiModelProperty(notes = "y轴坐标")
    private String y;
    @ApiModelProperty(notes = "验证码")
    private String code;
    @ApiModelProperty(value = "临时ticket", notes = "APP登录时用于确认预埋的分享人、渠道、来源等参数。")
    private String ticket;
}
