package com.baijiayun.duanxunbao.common.dto.key;

import lombok.Getter;

import java.util.concurrent.TimeUnit;

/**
 * desc: 将所有的redis key统一管理。
 *
 * @author yanmaoyuan
 */
@Getter
public enum RedisKeyEnum implements IRedisKey {

    BIZ_DOMAIN("biz:domain:%s", TimeUnit.DAYS, 30, "商户自定义域名"),
    BIZ_DOMAIN_BY_ID("biz:domain:byId:%s", TimeUnit.DAYS, 30, "通过bizId查询商户自定义域名"),
    BIZ_NUM("biz_num:%s", TimeUnit.DAYS, 1, "通过商户id获取num，或者通过num获取id"),
    BIZ_NODES("biz:nodes:%s", TimeUnit.MINUTES, 30, "商户组织架构"),

    BIZ_ALL("biz_all", TimeUnit.DAYS, 7, "商户缓存标志"),
    PARTNER_ALL("partner_all", TimeUnit.DAYS, 7, "百家云合作者缓存标志"),
    ORG_ALL("org_all", TimeUnit.DAYS, 7, "组织架构缓存标志"),
    USER_ALL("user_all", TimeUnit.DAYS, 7, "用户缓存标志"),
    USER_NODE("user_node", TimeUnit.DAYS, 7, "用户管理组织架构ID缓存标志"),
    USER_MANAGE_BIZ("user_manage_biz", TimeUnit.DAYS, 7, "用户管理商户ID缓存标志"),
    SYS_LIVE_DOMAIN("sys_live_domain", TimeUnit.DAYS, 7, "系统直播域名缓存标志"),

    TICKET("ticket_info:%s", TimeUnit.HOURS, 2, "临时票据，用于APP登录、进入直播间等需要携带渠道信息的接口。"),
    LOGIN_USER("login_user:%s:%s", TimeUnit.HOURS, 24, "登录用户信息"),

    // 短信验证码，需要两个参数，第一个参数是用户类型，第二个是手机号。
    LOGIN_SMS_VERIFY_CODE("login:sms:verify_code:%s:%s", TimeUnit.MINUTES, 10, "短信验证码"),
    LOGIN_SMS_VERIFY_ERROR_TIMES("login:sms:verify_error_times:%s:%s", TimeUnit.MINUTES, 10, "短信验证码错误次数"),
    LOGIN_SMS_VERIFY_COORDINATE("login:sms:verify_coordinate:%s:%s", TimeUnit.MINUTES, 10, "短信验证码坐标"),

    // 小程序绑定手机号
    XCX_BIND_SMS_CODE("xcx:bind:sms:code:%s", TimeUnit.MINUTES, 10, "小程序绑定手机号，短信验证码"),

    CAPTCHA("captcha:%s", TimeUnit.MINUTES, 10, "图形验证码"),

    // 百家云
    BJY_TOKEN("bjy_token:%s", TimeUnit.DAYS, 1, "百家云token"),

    TOKEN("token:%s", TimeUnit.SECONDS, 7200, "OpenAPI的token"),
    // OpenAPI 接口限流
    FIX_WINDOW_RATE_LIMIT_CONFIG("fix_window_rl_config:%s", TimeUnit.DAYS, 1, "固定窗口限流配置"),
    FIX_WINDOW_RATE_LIMIT_RECORD("fix_window_rl_record:%s:%s", TimeUnit.MINUTES, 1, "固定窗口限流记录"),
    FIX_TIME_RATE_LIMIT_CONFIG("fix_time_rl_config:%s", TimeUnit.DAYS, 1, "固定时间限流配置"),
    FIX_TIME_RATE_LIMIT_RECORD("fix_time_rl_record:%s:%s", TimeUnit.DAYS, 1, "固定时间限流记录"),

    // 直播间进出
    LIVE_IN_OUT_KEY("live_in_out:%d", TimeUnit.DAYS, 2, "直播进出记录并发实时缓存"),
    LIVE_NUM("live_num:%s", TimeUnit.DAYS, 1, "直播间号"),
    LIVE_BASE_INFO("live_base_info:%s", TimeUnit.DAYS, 1, "直播间基础信息"),
    LIVE_BASE_INFO_BY_ROOM_ID("live_base_info_by_room_id:%s", TimeUnit.DAYS, 1, "直播间基础信息"),
    LIVE_BASE_INFO_BY_BIZ_ID_ROOM_ID("live_base_info_by_biz_id_room_id:%s:%s", TimeUnit.DAYS, 1, "直播间基础信息"),

    LIVE_GOODS_REL("live_goods_rel:%s", TimeUnit.DAYS, 1, "缓存直播间商品关联记录"),
    LIVE_FLASH_SALE("live_flash_sale:%s", TimeUnit.DAYS, 1, "缓存直播间秒杀活动信息"),

    LIVE_GOODS_REL_ROOM_PRODUCT("live_goods_rel_room_product:%s:%s", TimeUnit.DAYS, 1, "缓存直播间商品关联记录"),

    LIVE_GROUP_MSG_ID("live_group_msg_id:%s", TimeUnit.MINUTES, 6, "直播群发消息拉取msgId缓存"),

    LIVE_SHARE_URL_KEY("live_share_url_ticket:%s:%s:%s", TimeUnit.DAYS, 1, "缓存用户进直播生成的share_url"),

    LIVE_PAY_RESULT_KEY("live_pay_result:%s", TimeUnit.HOURS, 1, "缓存直播带货支付接口返回的数据"),

    LIVE_WX_SHARE_CONFIG_KEY("live_wx_share_config:%s", TimeUnit.DAYS, 1, "缓存直播微信分享配置信息"),

    LIVE_ROOM_ID_2_MAIN_BIZ_ID_KEY("live_room_id_2_main_biz_id:%s", TimeUnit.DAYS, 1, "缓存直播间roomId 到 主商户bizId 的映射"),

    LIVE_WX_ASSIST("live_wx_assist:%s", TimeUnit.DAYS, 365, "缓存直播微信助教数据"),
    LIVE_WX_ASSIST_CUSTOMER_NUMS("live_wx_assist_customer_nums:%s", TimeUnit.DAYS, 365, "缓存直播微信助教数据"),

    LIVE_ROOM_UP_DOWN_KEY("live_room_up_down:%s",  TimeUnit.DAYS, 365, "缓存直播上课下课状态"),

    USER_NUM("user_num:%s", TimeUnit.DAYS, 7, "通过userId获取userNum"),
    USER_SIMPLE_INFO("user_simple_info:%s", TimeUnit.DAYS, 1, "用户基本信息"),

    TRADE_WAIT_PAY_ORDER_NOTIFY_QUEUE("trade_wait_pay_order_notify_queue:%s", TimeUnit.DAYS, 1, "待支付订单通知队列（实现订单超时未支付通知）"),

    EXPORT_COUNT_PREFIX("export_count_prefix_%s_%s", TimeUnit.DAYS, 365, "导出任务计数器前缀"),

    LIVE_ACCOUNT_OPEN_MODULE("live_account_open_moudle_%s_%s", TimeUnit.DAYS, 3, "直播账号开通大班课"),

    // 退出登录
    LOGIN_BLACK_LIST_KEY("login_black_list_%s", TimeUnit.DAYS, 7, "登录黑名单"),

    // 营期详情
    CAMP_PERIOD_DETAIL_KEY("camp_period_detail_%s", TimeUnit.MINUTES, 5, "营期详情"),
    // 营期目录
    CAMP_PERIOD_LESSON_KEY("camp_period_lesson_%s", TimeUnit.MINUTES, 5, "营期目录"),
    // 营期销售队列
    CAMP_SALES_QUEUE_KEY("camp_period_sales:%s", TimeUnit.DAYS, 365, "营期销售队列"),

    // 微信公众号授权登录后、微信小程序登录后 与token绑定
    WEIXIN_AUTH_INFO_TOKEN_RELATION("weixin_auth_info_token_relation:%s", TimeUnit.DAYS, 30, "微信公众号授权信息"),

    // 获取微信小程序授权链接时 会生成一个preAuthCode 将当时的 bizId等缓存下来
    XCX_PRE_AUTH_CODE_INFO("xcx_pre_auth_code_info:%s", TimeUnit.SECONDS, 500, "小程序获取授权链接时，缓存的信息"),

    // 任务进度
    TASK_PROGRESS("task_progress:%s", TimeUnit.MINUTES, 30, "任务进度"),
    TASK_PROGRESS_CURRENT("task_progress_current:%s", TimeUnit.MINUTES, 30, "任务进度当前值"),
    TASK_PROGRESS_STATE("task_progress_state:%s", TimeUnit.MINUTES, 30, "任务当前状态"),

    // 客户ES信息更新锁
    CUSTOMER_ES_LOCK("customer_es_lock:%s", TimeUnit.SECONDS, 10, "客户ES信息更新锁"),
    // 营期学员ES信息更新锁
    CAMP_STUDENT_ES_LOCK("camp_student_es_lock:%s", TimeUnit.SECONDS, 10, "营期学员ES信息更新锁"),
    // 导入营期学员的锁，避免 main_num 打通过的 customer 被重复导入。
    IMPORT_CAMP_STUDENT_CUSTOMER_LOCK("import_camp_student_customer:%s:%s", TimeUnit.MINUTES, 10, "营期学员导入锁"),

    // 转码回调锁
    VIDEO_TRANSCODE_CALLBACK_LOCK("video_transcode_callback_lock:%s", TimeUnit.SECONDS, 10, "转码回调锁"),

    COPY_LIVE_LOCK("copy_live:%s:%d", TimeUnit.SECONDS, 30, "复制直播"),
    // 批量新增虚拟用户
    VIRTUAL_USER_BATCH_ADD_KEY("virtual_user_batch_add", TimeUnit.MINUTES, 2, "虚拟用户批量新增"),

    SHORT_URL("short_url:%s", TimeUnit.DAYS, 7, "短链接"),
    //订单支付短信验证码
    ORDER_SMS_VERIFY_CODE("order:sms:verify_code:%s", TimeUnit.MINUTES, 10, "订单支付短信验证码"),

    RAND_VIRTUAL_USER_LIST("rand_virtual_user:%s", TimeUnit.HOURS, 12, "直播间随机虚拟用户列表"),

    // 客户可能使用小程序、公众号授权打开活动页面，因此产生不同的customer_num。这些customer_num应该对应到同一个 market_customer_info.
    // 第一个参数是活动id，第二个参数是客户customer_num
    MARKET_CUSTOMER_INFO_NUM("mc_info_num:%s:%s", TimeUnit.DAYS, 1, "营销客户信息, 记录 customer_num 对应的 info_num"),
    MARKET_CUSTOMER_INFO("mc_info:%s", TimeUnit.DAYS, 1, "营销客户信息"),
    MARKET_PLAN_ALL("market_plan_all", TimeUnit.DAYS, 7, "营销活动缓存标志"),
    MARKET_PLAN("market_plan:%s", TimeUnit.DAYS, 1, "营销活动详情"),
    MARKET_SHARE_LINK("vrp_url:%s", TimeUnit.DAYS, 1, "营销活动链接删除状态"),


    MARKET_PLAN_TOTAL_SHOULD_TRANS_AMOUNT("market_plan_total_should_trans_amount:%s", TimeUnit.DAYS, 365, "缓存每个planNum的活动应发放的总奖金"),

    WEWORK_USER_QR_CODE_BY_NUM("wework_user_qrcode:%s", TimeUnit.DAYS, 1, "通过weworkUserNum 获取对应的qr_code"),

    VIDEO_RED_PACKET_ANSWER_COUNT("vrp_answer_count:%s", TimeUnit.DAYS, 1, "视频红包活动客户答题次数"),
    VIDEO_RED_PACKET_SEND_REWARD("vrp_send_reward:%s", TimeUnit.SECONDS, 60, "发放奖励"),
    VIDEO_RED_PACKET_RESEND_REWARD("vrp_resend_reward:%s", TimeUnit.MINUTES, 10, "重新发放奖励"),

    APP_ACTIVITY_INFO("app_activity_info:%s", TimeUnit.HOURS, 24, "团购活动信息"),
    GOODS_BASE_INFO("goods_base_info:%s", TimeUnit.DAYS, 3, "商品基本信息"),

    QUICK_ENTER("quick_enter:%s", TimeUnit.DAYS, 30, "短连接快捷进入"),

    BLACK_LIST("black_list:%d", TimeUnit.DAYS, 3, "黑名单缓存标志"),

    PHONE_BATCH_KEY("phone_batch:%s", TimeUnit.HOURS, 3, "批量手机号缓存"),

    LIVE_STATISTIC_REFRESH_LOCK("live_statistic_refresh_lock:%s", TimeUnit.SECONDS, 10, "直播统计缓存刷新"),

    DELIVERY_LOGISTICS_INFO("delivery_logistics_info:%s", TimeUnit.SECONDS, 1800, "快递物流信息"),

    LIVE_CHAT_MSG_REFRESH("live_chat_msg_refresh:%s", TimeUnit.MINUTES, 5, "直播消息刷新"),

    LIVE_BIG_SCREEN_ROOM("live_big_screen_room", TimeUnit.MINUTES, 2, "直播大屏定时任务扫描的直播"),
    LIVE_BIG_SCREEN_USER("live_big_screen_user:%s", TimeUnit.MINUTES, 2, "直播大屏推送用户"),
    LIVE_BIG_SCREEN_DATA("live_big_screen_data:%s", TimeUnit.DAYS, 1, "直播大屏统计数据"),
    LIVE_BIG_SCREEN_LOCK("live_big_screen_lock:%s", TimeUnit.SECONDS, 60, "直播大屏统计推送锁"),

    BIZ_WECHAT_WEBSITE_CONFIG_KEY("biz_wechat_website_config:%s", TimeUnit.DAYS, 365, "商户微信网页应用配置信息"),

    /**
     * C端用户 进入密码观看直播 当输入密码成功后 且 有token的情况下
     * 将密码缓存起来 以便下次进入时 无需输入密码直接进直播间
     * key = live_app_user_room_password : live.num : customer.num
     */
    LIVE_APP_ROOM_USER_PASSWORD("live_app_room_user_password:%s:%s", TimeUnit.DAYS, 1, "C端用户进直播时输入的正确的密码"),

    /**
     * 同上
     */
    LIVE_APP_ROOM_PLAYBACK_USER_PASSWORD("live_app_room_playback_user_password:%s:%s", TimeUnit.DAYS, 1, "C端用户进回放时输入的正确的密码"),

    VIDEO_RED_PACKET_WHITE_LIST("video_red_packet_white_list:%d", TimeUnit.DAYS, 3, "视频红包通过审核的白名单缓存"),

    USER_ROLE_ID("user_role_id:%s", TimeUnit.HOURS, 24, "用户角色缓存"),
    PERMISSION_MENU_ID("permission_menu_id:%s", TimeUnit.HOURS, 24, "权限菜单缓存"),
    MENU_BIZ_ROLE_ID("menu_biz_role_id:%s", TimeUnit.MINUTES, 30, "菜单商户角色缓存"),

    GLOBAL_BLACK_LIST("global_black_list:%s", TimeUnit.DAYS, 7, "全局黑名单缓存"),
    LIVE_BLACK_LIST("live_black_list:%s", TimeUnit.DAYS, 7, "直播间黑名单缓存"),
    TEMP_BLACK_LIST("temp_black_list:%s", TimeUnit.MINUTES, 5, "临时黑名单缓存"),
    LIVE_WHITE_LIST("live_white_list:%s", TimeUnit.DAYS, 7, "直播间白名单缓存"),
    LIVE_WEWORK_WHITE_LIST("live_ww_white_list:%s:%s", TimeUnit.DAYS, 7, "直播间企微白名单缓存"),
    TEMP_WHITE_LIST("temp_white_list:%s", TimeUnit.MINUTES, 5, "临时白名单缓存"),

    OPEN_API_INVITE_USER_TICKET("open_api_invite_user_ticket:%s:%s", TimeUnit.DAYS, 1, "OpenAPI逻辑中员工的ticket"),

    SETTING("setting:%s:%s", TimeUnit.DAYS, 7, "系统配置参数"),

    GZH_BASE_INFO("gzh_base_info:%s", TimeUnit.MINUTES, 30, "公众号基础信息")
    ;

    public static final String STR_BIZ_TO_CORP_ID = "biz_to_corp_id";


    private final String key;
    private final TimeUnit timeUnit;
    private final long expireTime;
    private final String desc;

    RedisKeyEnum(String key, TimeUnit timeUnit, long expireTime, String desc) {
        this.key = key;
        this.timeUnit = timeUnit;
        this.expireTime = expireTime;
        this.desc = desc;
    }
}
