package com.baijiayun.duanxunbao.common.dto;

import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

/**
 * @title StrIdDto
 * @author yanmaoyuan
 * @date 2021年8月14日
 * @version 1.0
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "id请求参数")
public class StrIdDto extends BizIdAndUserIdReq {

    @ApiModelProperty(notes = "唯一编码", required = true, example = "1")
    private String id;

    public void validate(){
        Preconditions.checkArgument(StringUtils.isNotBlank(id), "id is null");
    }

    public void validateWithBizAndUser(){
        validateBizAndUser();
        Preconditions.checkArgument(StringUtils.isNotBlank(id), "id is null");
    }
}
