package com.baijiayun.duanxunbao.common.dto;

import com.google.common.base.Preconditions;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

/**
 * @author rockt
 * @version 1.0
 * @title AppStrIdDto
 * @date 2024年1月23日
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class AppStrIdDto extends AppBaseReq {

    protected String id;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(id), "id is null");
    }

    public void validateWithBiz() {
        Preconditions.checkArgument(bizId != null, "bizId is null");
        Preconditions.checkArgument(StringUtils.isNotBlank(id), "id is null");
    }
}
