/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api.license;

import cn.kinyun.wework.sdk.entity.license.setting.GetAutoActiveStatusResp;
import cn.kinyun.wework.sdk.entity.license.setting.SetAutoActiveStatusReq;
import cn.kinyun.wework.sdk.exception.WeworkException;

/**
 * Auto generate interface of LicenseSettingApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2023/05/31
 */
public interface LicenseSettingClient {

    /**
     * SetAutoActiveStatus
     *
     * @param corpId
     * @param req
     * @throws WeworkException
     */
    void setAutoActiveStatus(String corpId, SetAutoActiveStatusReq req) throws WeworkException;

    /**
     * GetAutoActiveStatus
     *
     * @param corpId
     * @param corpId
     * @return GetAutoActiveStatusResp
     * @throws WeworkException
     */
    GetAutoActiveStatusResp getAutoActiveStatus(String corpId) throws WeworkException;

}