/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api.license;

import cn.kinyun.wework.sdk.entity.license.account.*;
import cn.kinyun.wework.sdk.exception.WeworkException;

/**
 * Auto generate interface of LicenseAccountApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2023/05/31
 */
public interface LicenseAccountClient {

    /**
     * activeAccount
     *
     * @param corpId
     * @param req
     * @throws WeworkException
     */
    void activeAccount(String corpId, ActiveAccountReq req) throws WeworkException;

    /**
     * batchActiveAccount
     *
     * @param corpId
     * @param req
     * @return BatchActiveAccountResp
     * @throws WeworkException
     */
    BatchActiveAccountResp batchActiveAccount(String corpId, BatchActiveAccountReq req) throws WeworkException;

    /**
     * getActiveInfoByCode
     *
     * @param corpId
     * @param req
     * @return GetActiveInfoByCodeResp
     * @throws WeworkException
     */
    GetActiveInfoByCodeResp getActiveInfoByCode(String corpId, GetActiveInfoByCodeReq req) throws WeworkException;

    /**
     * batchGetActiveInfoByCode
     *
     * @param corpId
     * @param req
     * @return BatchGetActiveInfoByCodeResp
     * @throws WeworkException
     */
    BatchGetActiveInfoByCodeResp batchGetActiveInfoByCode(String corpId, BatchGetActiveInfoByCodeReq req) throws WeworkException;

    /**
     * listActivatedAccount
     *
     * @param corpId
     * @param req
     * @return ListActivatedAccountResp
     * @throws WeworkException
     */
    ListActivatedAccountResp listActivatedAccount(String corpId, ListActivatedAccountReq req) throws WeworkException;

    /**
     * getActiveInfoByUser
     *
     * @param corpId
     * @param req
     * @return GetActiveInfoByUserResp
     * @throws WeworkException
     */
    GetActiveInfoByUserResp getActiveInfoByUser(String corpId, GetActiveInfoByUserReq req) throws WeworkException;

    /**
     * batchTransferLicense
     *
     * @param corpId
     * @param req
     * @return BatchTransferLicenseResp
     * @throws WeworkException
     */
    BatchTransferLicenseResp batchTransferLicense(String corpId, BatchTransferLicenseReq req) throws WeworkException;

    /**
     * batchShareActiveCode
     *
     * @param corpId
     * @param req
     * @return BatchShareActiveCodeResp
     * @throws WeworkException
     */
    BatchShareActiveCodeResp batchShareActiveCode(String corpId, BatchShareActiveCodeReq req) throws WeworkException;

}