/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.entity.external.transfer.*;
import cn.kinyun.wework.sdk.exception.CrossBarrierException;
import cn.kinyun.wework.sdk.exception.WeworkException;

import java.util.Set;

/**
 * Auto generate interface of TransferApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface TransferClient {

    /**
     * transferCustomer
     *
     * @param corpId
     * @param params
     * @return TransferCustomerResp
     * @throws WeworkException
     */
    TransferCustomerResp transferCustomer(String corpId, TransferCustomerParams params) throws WeworkException;

    /**
     * 异步调用transferCustomer
     *
     * @param corpId
     * @param params
     * @return requestId
     */
    String asyncTransferCustomer(String corpId, TransferCustomerParams params);

    /**
     * getTransferResult
     *
     * @param corpId
     * @param handoverUserId
     * @param takeoverUserId
     * @param cursor
     * @return TransferResult
     * @throws WeworkException
     */
    TransferResult getTransferResult(String corpId, String handoverUserId, String takeoverUserId, String cursor) throws WeworkException;

    /**
     * getUnassignedList
     *
     * @param corpId
     * @param pageId
     * @param pageSize
     * @param cursor
     * @return UnassignedListResp
     * @throws WeworkException
     * @throws CrossBarrierException
     */
    UnassignedListResp getUnassignedList(String corpId, Integer pageId, Integer pageSize, String cursor) throws WeworkException, CrossBarrierException;

    /**
     * dimissionTransferCustomer
     *
     * @param corpId
     * @param params
     * @return TransferCustomerResp
     * @throws WeworkException
     */
    TransferCustomerResp dimissionTransferCustomer(String corpId, TransferCustomerParams params) throws WeworkException;

    /**
     * 异步调用dimissionTransferCustomer
     *
     * @param corpId
     * @param params
     * @return requestId
     */
    String asyncDimissionTransferCustomer(String corpId, TransferCustomerParams params);

    /**
     * getTransferResultOfDimission
     *
     * @param corpId
     * @param handoverUserId
     * @param takeoverUserId
     * @param cursor
     * @return TransferResult
     * @throws WeworkException
     */
    TransferResult getTransferResultOfDimission(String corpId, String handoverUserId, String takeoverUserId, String cursor) throws WeworkException;

    /**
     * transferGroupChat
     *
     * @param corpId
     * @param chatIds
     * @param newOwner
     * @return TransferGroupChatResp
     * @throws WeworkException
     */
    TransferGroupChatResp transferGroupChat(String corpId, Set<String> chatIds, String newOwner) throws WeworkException;

}