/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.external.massmsg.*;
import cn.kinyun.wework.sdk.entity.external.welcome.WelcomeMsg;
import cn.kinyun.wework.sdk.exception.WeworkException;

/**
 * Auto generate interface of MassMsgPushApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface MassMsgPushClient {

    /**
     * massMsgSend
     *
     * @param corpId
     * @param params
     * @return MassMsgResp
     * @throws WeworkException
     */
    MassMsgResp massMsgSend(String corpId, MassMsgParams params) throws WeworkException;

    /**
     * 异步调用massMsgSend
     *
     * @param corpId
     * @param params
     * @return requestId
     */
    String asyncMassMsgSend(String corpId, MassMsgParams params);

    /**
     * getMassMsgList
     *
     * @param corpId
     * @param params
     * @return MassMsgListResp
     * @throws WeworkException
     */
    MassMsgListResp getMassMsgList(String corpId, MassMsgListParams params) throws WeworkException;

    /**
     * getMassMsgUserTask
     *
     * @param corpId
     * @param msgId
     * @param limit
     * @param cursor
     * @return MassMsgUserTask
     * @throws WeworkException
     */
    MassMsgUserTask getMassMsgUserTask(String corpId, String msgId, Integer limit, String cursor) throws WeworkException;

    /**
     * getMassMsgTaskResult
     *
     * @param corpId
     * @param msgId
     * @param userId
     * @param limit
     * @param cursor
     * @return MassMsgTaskResult
     * @throws WeworkException
     */
    MassMsgTaskResult getMassMsgTaskResult(String corpId, String msgId, String userId, Integer limit, String cursor) throws WeworkException;

    /**
     * sendWelcomeMsg
     *
     * @param corpId
     * @param params
     * @throws WeworkException
     */
    void sendWelcomeMsg(String corpId, WelcomeMsg params) throws WeworkException;

    /**
     * 异步调用sendWelcomeMsg
     *
     * @param corpId
     * @param params
     * @return requestId
     */
    String asyncSendWelcomeMsg(String corpId, WelcomeMsg params);


    /**
     *  recallMsg
     *
     *  消息撤回
     * */
    ErrorCode recallMsg(String corpId, String msgId) throws  WeworkException;
}