/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.entity.external.joingroupmaterial.AddMaterialParams;
import cn.kinyun.wework.sdk.entity.external.joingroupmaterial.MaterialConfigResult;
import cn.kinyun.wework.sdk.entity.external.joingroupmaterial.MaterialInfo;
import cn.kinyun.wework.sdk.entity.external.joingroupmaterial.UpdateMaterialParams;
import cn.kinyun.wework.sdk.exception.WeworkException;

/**
 * Auto generate interface of JoinGroupMaterialApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface JoinGroupMaterialClient {

    /**
     * add
     *
     * @param corpId
     * @param params
     * @return MaterialConfigResult
     * @throws WeworkException
     */
    MaterialConfigResult add(String corpId, AddMaterialParams params) throws WeworkException;

    /**
     * 异步调用add
     *
     * @param corpId
     * @param params
     * @return requestId
     */
    String asyncAdd(String corpId, AddMaterialParams params);

    /**
     * get
     *
     * @param corpId
     * @param templateId
     * @return MaterialInfo
     * @throws WeworkException
     */
    MaterialInfo get(String corpId, String templateId) throws WeworkException;

    /**
     * update
     *
     * @param corpId
     * @param params
     * @throws WeworkException
     */
    void update(String corpId, UpdateMaterialParams params) throws WeworkException;

    /**
     * 异步调用update
     *
     * @param corpId
     * @param params
     * @return requestId
     */
    String asyncUpdate(String corpId, UpdateMaterialParams params);

    /**
     * delete
     *
     * @param corpId
     * @param templateId
     * @throws WeworkException
     */
    void delete(String corpId, String templateId) throws WeworkException;

    /**
     * 异步调用delete
     *
     * @param corpId
     * @param templateId
     * @return requestId
     */
    String asyncDelete(String corpId, String templateId);

}