/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api.external;

import cn.kinyun.wework.sdk.entity.external.groupchat.ChatDetailInfo;
import cn.kinyun.wework.sdk.entity.external.groupchat.ExternalGroupChatListResp;
import cn.kinyun.wework.sdk.enums.ChatStatusFilter;
import cn.kinyun.wework.sdk.exception.WeworkException;

import java.util.List;

/**
 * Auto generate interface of ExternalChatApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface ExternalChatClient {

    /**
     * list
     *
     * @param corpId
     * @param statusFilter
     * @param userIds
     * @param cursor
     * @param limit
     * @return ExternalGroupChatListResp
     * @throws WeworkException
     */
    ExternalGroupChatListResp list(String corpId, ChatStatusFilter statusFilter, List<String> userIds, String cursor, Integer limit) throws WeworkException;

    /**
     * detail
     *
     * @param corpId
     * @param chatId
     * @return ChatDetailInfo
     * @throws WeworkException
     */
    ChatDetailInfo detail(String corpId, String chatId) throws WeworkException;

}