/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.entity.oauth2.UserDetail;
import cn.kinyun.wework.sdk.entity.oauth2.Userdetail3rd;
import cn.kinyun.wework.sdk.entity.oauth2.Userinfo;
import cn.kinyun.wework.sdk.entity.oauth2.Userinfo3rd;
import cn.kinyun.wework.sdk.exception.WeworkException;

/**
 * Auto generate interface of WwOauth2Api.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface WwOauth2Client {

    /**
     * getUserdetail
     *
     * @param corpId
     * @param userTicket
     * @return UserDetail
     * @throws WeworkException
     */
    UserDetail getUserdetail(String corpId, String userTicket) throws WeworkException;

    /**
     * getUserinfo3rd
     *
     * @param suiteId
     * @param code
     * @return Userinfo3rd
     * @throws WeworkException
     */
    Userinfo3rd getUserinfo3rd(String suiteId, String code) throws WeworkException;

    /**
     * getUserinfo
     *
     * @param corpId
     * @param code
     * @return Userinfo
     * @throws WeworkException
     */
    Userinfo getUserinfo(String corpId, String code) throws WeworkException;

    /**
     * getUserdetail3rd
     *
     * @param suiteId
     * @param userTicket
     * @return Userdetail3rd
     * @throws WeworkException
     */
    Userdetail3rd getUserdetail3rd(String suiteId, String userTicket) throws WeworkException;

}