/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.api.req.AddScheduleReq;
import cn.kinyun.wework.sdk.api.req.DelScheduleReq;
import cn.kinyun.wework.sdk.api.req.UpdateScheduleReq;
import cn.kinyun.wework.sdk.entity.calendar.ScheduleAddResp;
import cn.kinyun.wework.sdk.exception.WeworkException;

/**
 * Auto generate interface of ScheduleApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface ScheduleClient {

    /**
     * addSchedule
     *
     * @param corpId
     * @param params
     * @return ScheduleAddResp
     * @throws WeworkException
     */
    ScheduleAddResp addSchedule(String corpId, AddScheduleReq params) throws WeworkException;

    /**
     * 异步调用addSchedule
     *
     * @param corpId
     * @param params
     * @return requestId
     */
    String asyncAddSchedule(String corpId, AddScheduleReq params);

    /**
     * updateSchedule
     *
     * @param corpId
     * @param params
     * @throws WeworkException
     */
    void updateSchedule(String corpId, UpdateScheduleReq params) throws WeworkException;

    /**
     * 异步调用updateSchedule
     *
     * @param corpId
     * @param params
     * @return requestId
     */
    String asyncUpdateSchedule(String corpId, UpdateScheduleReq params);

    /**
     * delSchedule
     *
     * @param corpId
     * @param params
     * @throws WeworkException
     */
    void delSchedule(String corpId, DelScheduleReq params) throws WeworkException;

    /**
     * 异步调用delSchedule
     *
     * @param corpId
     * @param params
     * @return requestId
     */
    String asyncDelSchedule(String corpId, DelScheduleReq params);

}