/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.entity.chat.ChatData;
import cn.kinyun.wework.sdk.entity.chat.MediaData;
import cn.kinyun.wework.sdk.entity.chat.PermitUserDto;
import cn.kinyun.wework.sdk.exception.WeworkException;

/**
 * Auto generate interface of FinanceApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface FinanceClient {

    /**
     * getPermitUserList
     *
     * @param corpId
     * @param type
     * @return PermitUserDto
     * @throws WeworkException
     */
    PermitUserDto getPermitUserList(String corpId, Integer type) throws WeworkException;

    /**
     * getChatData
     *
     * @param corpId
     * @param seq
     * @param limit
     * @return ChatData
     * @throws WeworkException
     */
    ChatData getChatData(String corpId, Long seq, Integer limit) throws WeworkException;

    /**
     * getMediaData
     *
     * @param corpId
     * @param fileId
     * @param authKey
     * @return MediaData
     * @throws WeworkException
     */
    MediaData getMediaData(String corpId, String fileId, String authKey) throws WeworkException;

}