/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.api.req.AddCalendarReq;
import cn.kinyun.wework.sdk.api.req.CalendarDetailReq;
import cn.kinyun.wework.sdk.entity.calendar.CalendarAddResp;
import cn.kinyun.wework.sdk.entity.calendar.CalendarDetailResp;
import cn.kinyun.wework.sdk.exception.WeworkException;

/**
 * Auto generate interface of CalendarApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface CalendarClient {

    /**
     * addCalendar
     *
     * @param corpId
     * @param params
     * @return CalendarAddResp
     * @throws WeworkException
     */
    CalendarAddResp addCalendar(String corpId, AddCalendarReq params) throws WeworkException;

    /**
     * getCalendarDetail
     *
     * @param corpId
     * @param params
     * @return CalendarDetailResp
     * @throws WeworkException
     */
    CalendarDetailResp getCalendarDetail(String corpId, CalendarDetailReq params) throws WeworkException;

}