/*
 * kinyun.cn Inc.
 * Copyright (c) 2022. All Rights Reserved.
 */
package cn.kinyun.wework.sdk.api;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import cn.kinyun.wework.sdk.entity.agent.*;
import cn.kinyun.wework.sdk.entity.agent.userid.UserIds;
import cn.kinyun.wework.sdk.exception.WeworkException;

import java.util.List;

/**
 * Auto generate interface of AgentApi.
 *
 * @author yanmaoyuan@baijiayun.com
 * @since 2022/12/14
 */
public interface AgentClient {

    /**
     * getAgent
     *
     * @param corpId
     * @param agentId
     * @return Agent
     * @throws WeworkException
     */
    Agent getAgent(String corpId, Integer agentId) throws WeworkException;

    /**
     * getAgentList
     *
     * @param corpId
     * @return AgentList
     * @throws WeworkException
     */
    AgentList getAgentList(String corpId) throws WeworkException;

    /**
     * setAgent
     *
     * @param corpId
     * @param params
     * @throws WeworkException
     */
    void setAgent(String corpId, SetAgentParams params) throws WeworkException;

    /**
     * sendMsg
     *
     * @param corpId
     * @param msg
     * @return SendMsgResult
     * @throws WeworkException
     */
    SendMsgResult sendMsg(String corpId, AgentMsgBase msg) throws WeworkException;

    /**
     * 异步调用sendMsg
     *
     * @param corpId
     * @param msg
     * @return requestId
     */
    String asyncSendMsg(String corpId, AgentMsgBase msg);

    /**
     * convertOpenUserId
     *
     * @param corpId
     * @param openUserIdList
     * @param sourceAgentId
     * @return UserIds
     * @throws WeworkException
     */
    UserIds convertOpenUserId(String corpId, List<String> openUserIdList, Integer sourceAgentId) throws WeworkException;

    /**
     * convertOpenExternalUserId
     *
     * @param corpId
     * @param externalUserId
     * @param sourceAgentId
     * @return String
     * @throws WeworkException
     */
    String convertOpenExternalUserId(String corpId, String externalUserId, Integer sourceAgentId) throws WeworkException;


}