/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.pay.business.status;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum TransStatus {
    TRANS_MARK(-3, "\u8f6c\u8d26\u8bbe\u4e3a\u5df2\u652f\u4ed8"),
    TRANS_REJECT(-2, "\u8f6c\u8d26\u62d2\u7edd"),
    TRANS_STATUS_AUDIT(-1, "\u8f6c\u8d26\u5f85\u5ba1\u8ba1"),
    TRANS_STATUS_DRAFT(0, "\u8349\u7a3f"),
    TRANS_STATUS_DEALING(1, "\u5904\u7406\u4e2d"),
    TRANS_STATUS_SUCC(2, "\u6210\u529f"),
    TRANS_STATUS_FAILED(3, "\u5931\u8d25"),
    TRANS_STATUS_REFUNDED(4, "\u9000\u7968");

    private Integer value;
    private String desc;
    private static final Map<Integer, TransStatus> MAP;
    public static final Set<Integer> finalStatusSet;

    public static TransStatus get(Integer value) {
        return MAP.get(value);
    }

    public static Set<Integer> getFinalStatusSet() {
        return finalStatusSet;
    }

    private TransStatus(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public Integer getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        MAP = Arrays.stream(TransStatus.values()).collect(Collectors.toMap(a -> a.getValue(), a -> a));
        finalStatusSet = Sets.newHashSet((Object[])new Integer[]{TRANS_STATUS_FAILED.getValue(), TRANS_STATUS_REFUNDED.getValue()});
    }
}

